#*************************************************************************
# FILE NAME: init.s                       COPYRIGHT (c) Freescale 2010    
#                                                All Rights Reserved      
#
# This is the standard PPC init code. 
#*************************************************************************

# register defines
	
	.novle
	.globl __start

	.section .rcw, ax
	.long 0x005a0000
	.long __start

	.section .init,ax     		# The "ax" generates symbols for debug

__start:


#*****************************
# Enable SPE
#*****************************
	mfmsr r6
	oris  r6, r6, 0x0200
	mtmsr r6
	
	wrteei  1
		
#***************
# Clear Timebase
#***************
  li r3, 0
  mtspr 284, r3
  mtspr 285, r3

#****************
# Enable Timebase
#****************
  li r3, 0x4000
  mtspr HID0, r3

#***********************
# Configure MMU SRAM - No VLE
#***********************
#TLB2 =  1MB for Internal RAM
   lis r3, 0x1003
   mtmas0 r3
   lis  r3, 0xC000
   ori  r3, r3, 0x0500
   mtmas1 r3
   lis  r3, 0x4000
   ori  r3, r3, 0x0000
   mtmas2 r3
   lis  r3, 0x4000
   ori  r3, r3, 0x003F
   mtmas3 r3
   tlbwe


#***********************
# Initialize ECC in SRAM
# 596K of RAM
#***********************
  li   r5, 2048
  mtctr r5
  lis   r5,0x4000
sram_loop:
  stmw  r0, 0x0 (r5)
  addi  r5, r5, 128
  bdnz  sram_loop

#********************************
# Enable the branch target buffer
#********************************
  li	r0, 0x201
  mtspr	1013, r0

#******************
# configure the MMU
#******************
#TLB0 = pbridgeB (configured by BAM)

#TLB1 =  1M Internal flash - z6 - No VLE
# Execute from RAM

  b copy_to_ram

tlb1_config:
   lis r3, 0x1001
   mtmas0 r3
   lis  r3, 0xC000
   ori r3, r3, 0x0500
   mtmas1	r3

   lis  r3, 0x0000
   ori r3, r3, 0x0000
   mtmas2	 r3

   lis  r3, 0x0000
   ori  r3, r3, 0x003F
   mtmas3	 r3
   tlbwe
   blr
   
copy_to_ram:
  lis r3, tlb1_config@h
  ori r3, r3, tlb1_config@l
  lis r4, copy_to_ram@h
  ori r4, r4, copy_to_ram@l
  subf r4, r3, r4
  mtctr r4
  lis r5, 0x4000
  mtlr r5

copy:
  lbz r6, 0(r3)
  stb r6, 0(r5)
  addi r3, r3, 1
  addi r5, r5, 1
  bdnz copy

  blrl

#TLB2 =  1M Internal flash - z0
   lis r3, 0x1002
   mtmas0 r3
   lis  r3, 0xC000
   ori   r3, r3, 0x0500
   mtmas1 r3
   lis  r3, 0x0010
   ori  r3, r3, 0x0020
   mtmas2 r3
   lis  r3, 0x0010
   ori  r3, r3, 0x003F
   mtmas3 r3
   tlbwe

#TLB4 =  pbridgeA
   lis r3, 0x1004
   mtmas0 r3
   lis  r3, 0xC000
   ori  r3, r3, 0x0800
   mtmas1 r3
   lis  r3, 0xC000
   ori  r3, r3, 0x000A
   mtmas2 r3
   lis  r3, 0xC000
   ori  r3, r3, 0x003F
   mtmas3 r3
   tlbwe

#****************************
# Call start code (_start)
#****************************
	
  bl _start
loop_forever:
  b loop_forever





  
